﻿/*

"loc_langs" - the object holding all items that need localizations

In order for translations to work, the string in HTML source
should be encapsulated in a <span> with a class set to "l_"
PLUS the unique name of the sub-object containing its
translations.

For example, to translate "Install all" in HTML source, find
(or add) that sub-item in the langs object.  It already
exists with a name of "installAll".  Therefore the <span>
surrounding the text in the HTML source should be assigned a
class of "l_installAll". Example:

    <span class="l_installAll">Install all</span>

It's easy enough to add new translated strings.  Simply copy
one of the existing below, give it a unique name, and enter
the translated strings.  Then add the "l_" + unique name
class to a <span> around the original string in the HTML
source.
*/

loc_supportedLangs = [
"en", // English
"ptb", // Portuguese (Brazilian)
"de", // German
"fr", // French
"es", // Spanish
"it", // Italian
"ko", // Korean
"jp", // Japanese
"ch", // Chinese (Simplified)
];

loc_langs = {


  thanks: {
    en: 'Thanks for choosing UltraCompare.',
    ptb: 'Obrigado por escolher o UltraCompare',
    de: 'Vielen Dank, dass Sie sich f&uuml;r UltraCompare entschieden haben!',
    fr: 'Merci d\'avoir choisi UltraCompare',
    es: 'Gracias por elegir UltraCompare',
    it: 'Grazie per aver scelto UltraCompare',
    ko: 'UltraCompare를 선택해 주셔서 감사합니다',
    jp: 'UltraCompareを選択していただき、ありがとうございます',
    ch: '感谢您选择 UltraCompare。',
  },

  getStarted: {
    en: 'To get started, select a new compare below:',
    ptb: 'Para começar, selecione uma nova comparação abaixo:',
    de: 'Wählen Sie einen neuen Vergleich unten, um zu beginnen:',
    fr: 'Pour commencer, sélectionnez une nouvelle comparaison ci-dessous :',
    es: 'Para comenzar, seleccione una nueva comparación a continuación:',
    it: 'Per iniziare, seleziona un nuovo confronto di seguito:',
    ko: '시작하려면 아래에서 새 비교를 선택하십시오:',
    jp: '開始するには、以下の新規比較セッションを選択してください。',
    ch: '开始时请在下面选择一个新比较：',
  },

  compareText: {
    en: 'Text',
    ptb: 'Texto',
    de: 'Text',
    fr: 'Texte',
    es: 'Texto',
    it: 'Testo',
    ko: '텍스트',
    jp: 'テキスト',
    ch: '文本',
  },

  compare3text: {
    en: '3-way text',
    ptb: 'Texto de 3 vias',
    de: '3-fach-Text',
    fr: '3 fichiers texte',
    es: 'Texto de 3 vías',
    it: 'Testo 3-Way',
    ko: '3개 텍스트 모드',
    jp: '<span style="font-size: 90%;">3-Wayテキストモード</span>',
    ch: '三方文本模式',
  },

  compareDoc: {
    en: 'Doc',
    ptb: 'Doc',
    de: 'Dokument',
    fr: 'Doc',
    es: 'Doc',
    it: 'Doc',
    ko: '문서',
    jp: 'ドキュメント',
    ch: '文件',
  },

  comparePdf: {
    en: 'PDF',
    ptb: 'PDF',
    de: 'PDF',
    fr: 'PDF',
    es: 'PDF',
    it: 'PDF',
    ko: 'PDF',
    jp: 'PDF',
    ch: 'PDF',
  },

  compareFolder: {
    en: 'Folder',
    ptb: 'Pasta',
    de: 'Verzeichnis',
    fr: 'Dossier',
    es: 'Carpeta',
    it: 'Cartella',
    ko: '폴더',
    jp: 'フォルダモード',
    ch: '文件夹',
  },

  compare3folder: {
    en: '3-way folder',
    ptb: 'Pasta de 3 vias',
    de: '<span style="font-size: 85%;">3-fach-Verzeichnis</span>',
    fr: '3 dossiers',
    es: '<span style="font-size: 85%;">Carpetas de 3-Vías</span>',
    it: 'Cartelle 3-Way',
    ko: '3개 폴더 모드',
    jp: '<span style="font-size: 85%;">3-Way フォルダモード</span>',
    ch: '三方文本模式',
  },

  compareTable: {
    en: 'Table',
    ptb: 'Tabela',
    de: 'Tabelle',
    fr: 'Table',
    es: 'Tabla',
    it: 'Tabella',
    ko: '문자표',
    jp: 'テーブル',
    ch: '字符表',
  },

  compareBinary: {
    en: 'Binary',
    ptb: 'Binária',
    de: 'Binär',
    fr: 'Binaire',
    es: 'Binaria',
    it: 'Binario',
    ko: '바이너리',
    jp: 'バイナリ',
    ch: '二进制',
  },

};